using UnityEditor.Build.Reporting;

namespace UnityEditor.HiveEditor
{
    public readonly struct HivePostBuildContext
    {
        public readonly BuildSummary Summary;

#if UNITY_STANDALONE_WIN
        public readonly string PluginDeployPath;
#endif

#if UNITY_STANDALONE_WIN
        public HivePostBuildContext(BuildSummary summary, string pluginDeployPath)
        {
            Summary          = summary;
            PluginDeployPath = pluginDeployPath;
        }
#else
        public HivePostBuildContext(BuildSummary summary)
        {
            Summary = summary;
        }
#endif
    }
}